<?php
/**
 * Enqueue parent and child theme styles.
 */
function twentyten_theme_css_enqueue_styles() {
    wp_enqueue_style('twentyten-style', get_template_directory_uri() . '/style.css');
    wp_enqueue_style('twentyten_theme_css-style', get_stylesheet_uri(), array('twentyten-style'));
}
add_action('wp_enqueue_scripts', 'twentyten_theme_css_enqueue_styles');

/**
 * Load frontend scripts
 */
add_action('wp_enqueue_scripts', 'load_scripts_styles', 9);
function load_scripts_styles()
{
wp_enqueue_style('w3css', 'https://www.w3schools.com/w3css/4/w3.css'); // supreme gallery
wp_enqueue_style('font-awesome4', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css');
// wp_enqueue_script('iconify', 'https://code.iconify.design/1/1.0.3/iconify.min.js');
}

// https://stackoverflow.com/questions/40603968/wordpress-custom-excerpt-length-not-working/59549159#59549159 
// https://stackoverflow.com/questions/40603968/wordpress-custom-excerpt-length-not-working 
// https://www.hostinger.com/tutorials/wordpress-excerpt-length/
// http://www.justthink.it/articles/display-excerpts-categories-wordpress-twenty-sixteen-theme/ 
// https://developer.wordpress.org/reference/functions/the_excerpt/
// https://wordpress.stackexchange.com/questions/139953/excerpt-length-not-working 
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );
function custom_excerpt_length( $length ) {
    return 30;
}

// https://smallenvelop.com/limit-post-excerpt-length-in-wordpress/
// https://technumero.com/limit-excerpt-length-wordpress/
function excerpt($limit)
{
    $excerpt = explode(' ', get_the_excerpt(), $limit);
    if (count($excerpt) >= $limit) {
        array_pop($excerpt);
        $excerpt = implode(" ", $excerpt) . '...';
    } else {
        $excerpt = implode(" ", $excerpt);
    }
    // $excerpt = preg_replace('`[[^]]*]`', '', $excerpt);
    $excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
    return $excerpt;
}
function content($limit)
{
    $content = explode(' ', get_the_content(), $limit);
    if (count($content) >= $limit) {
        array_pop($content);
        $content = implode(" ", $content) . '...';
    } else {
        $content = implode(" ", $content);
    }
    $content = preg_replace('/[.+]/', '', $content);
    $content = apply_filters('the_content', $content);
    $content = str_replace(']]>', ']]>', $content);
    return $content;
}

function get_blog_posts_page_url() {
	// If front page is set to display a static page, get the URL of the posts page.
	if ( 'page' === get_option( 'show_on_front' ) ) {
		return get_permalink( get_option( 'page_for_posts' ) );
	}
	// The front page is the posts page. Get its URL.
	return get_home_url();
}

// Number Pagination Function
function gamayun_number_pagination()
{
    global $wp_query;
    $big = 9999999; // need an unlikely integer
    echo wp_kses_post(paginate_links(array(
        'base' => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
        'format' => '?paged=%#%',
        'current' => max(1, get_query_var('paged')),
        'total' => $wp_query->max_num_pages)));
}

function magma22_date()
    {
        ?>
    <p><i class="fa fa-clock-o"></i>
    <!-- Retrieves the permalink for the month archives with year. / get_year_link(); get_month_link; get_day_link -->
    <?php
    $archive_year = get_the_time('Y');
        $archive_month = get_the_time('m');
        $archive_day = get_the_time('d');
        ?>
    <a href="<?php echo esc_url(get_month_link($archive_year, $archive_month)); ?>"><?php echo get_the_date(); ?></a>
    
    <?php // Count number of posts of current month - https://wordpress.stackexchange.com/questions/88645/count-number-of-posts-of-current-month
        $month = get_the_time('m');
        $year_l = get_the_time('Y');
        $countposts = get_posts(array(
            'numberposts' => -1, // phpcs:ignore WPThemeReview.CoreFunctionality.PostsPerPage.posts_per_page_numberposts
            'post_type' => 'post',
            'year' => $year_l,
            'monthnum' => $month,
        ));
        echo '(' . count($countposts) . ')';
        ?></p>
    
    <?php
    }
    
    
function magma22_entrymeta()
{
    ?><h4 class="w3-text-black">Post information:</h4><?php
    global $authordata;
    $link_l = get_author_posts_url($authordata->ID, $authordata->user_nicename);
    $link_l = sprintf('<a href="%1$s" title="%2$s" rel="author">%3$s</a>',
        esc_url(add_query_arg('post_type', 'post', $link_l)),
        esc_attr(sprintf('Posts by %s', get_the_author())),
        get_the_author()
    ) . '(' . count_user_posts(get_the_author_meta('ID'), 'post') . ')';
    ?>
<p><i class="fa fa-pencil"></i> author: <?php echo  wp_kses_post($link_l); ?></p>

<?php
    magma22_date();

    // ***** post all categories
    $terms = wp_get_post_terms(get_the_ID(), 'category');
    $links = '';
    foreach ($terms as $t) {
        $tl = is_wp_error($term_link = get_term_link($t->slug, 'category')) ? '' : $term_link;
        $links .= '<a href="' . $tl . '">' . $t->name . '</a>' . '(' . $t->count . ')' . ' ';
    }
    printf("<p><i class='fa fa-folder-open'></i> " . '<span style="font-variant:small-caps;">' . "Categories: " . '</span>' . '<span class="entry-cat">' . '%1$s' . '</span></p>', wp_kses_post($links));

    // ***** post all tags
    $terms = wp_get_post_terms(get_the_ID(), 'post_tag');
    $links = '';
    foreach ($terms as $t) {
        $links .= '<a href="' . get_term_link($t->slug, 'post_tag') . '">' . $t->name . '(' . $t->count . ')' . '</a>' . ' ';
    }
    printf("<p><i class='fa fa-tags'></i> " . '<span style="font-variant:small-caps;">' . "Tags: " . '</span>' . '<span class="entry-tag">' . '%1$s' . '</span></p>', wp_kses_post($links));

    // comment
     ?><p><i class='fa fa-comment-o'></i> <?php comments_popup_link('No comments yet', '1 comment', '% comments', 'comments-link', 'Comments are off for this post');?>
        </p><?php
}

?>
